#ifndef NASCCL_NASCCL_H
#define NASCCL_NASCCL_H
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define NASCCLByte unsigned char

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define AlgorithmName      "NASCCL"
#define AlgorithmVersion   "1.0.2.8"

#define BoxSize            64
#define BoxValues          256

#define MaxKeyLength       10240
#define MaxBitStrength     (MaxKeyLength * 8)

#define MinKeyLength       6
#define MinBitStrength     (MinKeyLength * 8)

#define ROUNDMUTATION      0x0001
#define SWAPMATRIX         0x0002
#define ROUNDRESULT        0x0004
#define NONREPETITION      0x0010
#define ENSUREOFFSET       0x0020
#define FMATRIXMUTATION    0x0040
#define RMATRIXMUTATION    0x0080
#define CMATRIXMUTATION    0x0100
#define CRYPTFULLDATASET   0x0200
#define RUNNINGKEYPOSITION 0x0400
#define CIPHERUSERSKEY     0x0800

#define GKNUMBERS       0x0001
#define GKUPPER_AZ      0x0002
#define GKLOWER_AZ      0x0004
#define GKBROADKEY      0x0010
#define GKNONREPETITION 0x0020

/*
#define A04 0x1000
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class NASCCL{
    public:
        //-------------(Functions)
        bool Decode(void *DataIn, void *DataOut, int DataSize);
        bool Encode(void *DataIn, void *DataOut, int DataSize);
        bool InitializeCryptographySet(void *Key, int SizeOfKey, int Attribute);
        bool UninitializeCryptographySet(void);

    private:
        //-------------(Variables)
        int Attribute;
        int KeyHashPos;
        int KeyHashLen;

        NASCCLByte *KeyHash;

        NASCCLByte Matrix[6][6]; // (288-Bit Matrix) ((6 * 6) * 8)
        NASCCLByte MValue[6][6]; // (288-Bit Matrix) ((6 * 6) * 8)

        //-------------(Functions)
        void MatrixMutate(NASCCLByte MValue);
        void SwapMatrix(int Swap, int With);
};

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CipherKey(void *InputKey, void *OutputKey, int SizeOfKey);
bool GenerateKey(int inKeyLength, int inSeed, int inAttribute, void *outNewKey);
bool HashKey(void *InputKey, void *OutputKey, int SizeOfKey, int FinalSize);

char *GetAlgorithmName(void);
char *GetAlgorithmVersion(void);

int GenerateSeed(void);
int GetMaxBitStrength(void);
int GetMaxKeyLength(void);
int GetMinBitStrength(void);
int GetMinKeyLength(void);

NASCCLByte Merge(NASCCLByte Value1, NASCCLByte Value2, NASCCLByte Value3, NASCCLByte Value4, NASCCLByte Value5, NASCCLByte Value6);

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

